% LOAD DATA FROM LOG FILES WITH DIFFERENT PRECONDITIONERS
tFast = load_tmatch('frank_wolfe.log');
tSlow = load_tmatch('frank_wolfe_dz_preconditioner.log');
tNone = load_tmatch('frank_wolfe_no_preconditioner.log');

% PLOT
figure(3); clf;
set(gcf,'Position',[1 1 1500 625]);
axes('Position',[0.075 0.15 0.875 0.75]);
nbins = 12;
histogram(log10(tFast),nbins); hold on;
histogram(log10(tSlow),nbins);
histogram(log10(tNone),nbins);
grid on;
set(gca,'LineWidth',2);
set(gca,'FontSize',24);
set(gcf,'Color','w');
set(gca,'XTick',log10([10:10:90 100:100:1000]));
set(gca,'XLim',[0.9 3]);
set(gca,'XTickLabel',{'10^1','','','','','','','','',...
  '10^2','','','','','','','','','10^3'});
set(gca,'XTickLabelRotation',0);
set(gca,'GridLineStyle','-','GridLineWidth',1);
set(gcf, 'InvertHardcopy','off');
xl = xlabel('seconds');
set(xl,'Position',[1.95 -4 -1]);
lgd = legend(' diagonal-decreasing ',' diagonal-zeroing ',' none ');
set(lgd,'Position',[0.43 0.65 0.2 0.16]);
tt = title('perfect matching with different preconditioners');
set(tt,'Position',[1.95 41.5 0]);
set(gcf,'PaperPositionMode','auto');
set(gcf,'PaperUnits','inches','PaperSize',[10 7]);
print -dpng fig_match.png;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function tMatch = load_tmatch(filename)

wd = cd;
logfile = sprintf('%s/log/%s',wd(1:end-4),filename);
data = load(logfile);
tMatch = data(2:end,end);

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
